/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class SpecialFunctionNode
extends ValueNode {
    String sqlName;
    static final int K_IDENTITY_VAL = 0;
    static final int K_CURRENT_ISOLATION = 1;
    static final int K_CURRENT_SCHEMA = 2;
    static final int K_USER = 3;
    static final int K_CURRENT_USER = 4;
    static final int K_SESSION_USER = 5;
    static final int K_SYSTEM_USER = 6;
    static final int K_CURRENT_ROLE = 7;
    final int kind;
    private String methodName;
    private String methodType;

    SpecialFunctionNode(int n, ContextManager contextManager) {
        super(contextManager);
        this.kind = n;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        switch (this.kind) {
            case 3: 
            case 4: 
            case 6: {
                switch (this.kind) {
                    case 3: {
                        this.sqlName = "USER";
                        break;
                    }
                    case 4: {
                        this.sqlName = "CURRENT_USER";
                        break;
                    }
                    case 6: {
                        this.sqlName = "SYSTEM_USER";
                    }
                }
                this.methodName = "getCurrentUserId";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 5: {
                this.methodName = "getSessionUserId";
                this.methodType = "java.lang.String";
                this.sqlName = "SESSION_USER";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 2: {
                this.sqlName = "CURRENT SCHEMA";
                this.methodName = "getCurrentSchemaName";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 7: {
                this.sqlName = "CURRENT_ROLE";
                this.methodName = "getCurrentRoleIdDelimited";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, 258);
                break;
            }
            case 0: {
                this.sqlName = "IDENTITY_VAL_LOCAL";
                this.methodName = "getIdentityValue";
                this.methodType = "java.lang.Long";
                dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 31, 0, true, 31);
                break;
            }
            case 1: {
                this.sqlName = "CURRENT ISOLATION";
                this.methodName = "getCurrentIsolationLevelStr";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 2);
                break;
            }
            default: {
                dataTypeDescriptor = null;
            }
        }
        this.checkReliability(this.sqlName, 64);
        this.setType(dataTypeDescriptor);
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        int n = 0;
        if (this.methodName.equals("getCurrentRoleIdDelimited") || this.methodName.equals("getCurrentSchemaName") || this.methodName.equals("getCurrentUserId")) {
            expressionClassBuilder.pushThisAsActivation(methodBuilder);
            ++n;
        }
        methodBuilder.callMethod((short)185, null, this.methodName, this.methodType, n);
        String string = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType(), localField);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((SpecialFunctionNode)valueNode).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        if (this.isSameNodeKind(valueNode)) {
            SpecialFunctionNode specialFunctionNode = (SpecialFunctionNode)valueNode;
            return this.methodName.equals(specialFunctionNode.methodName);
        }
        return false;
    }
}

