/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import org.openide.util.Utilities;

public class Parameters {
    private Parameters() {
    }

    public static void notNull(CharSequence charSequence, Object object) {
        if (object == null) {
            throw new NullPointerException("The " + charSequence + " parameter cannot be null");
        }
    }

    public static void notEmpty(CharSequence charSequence, CharSequence charSequence2) {
        Parameters.notNull(charSequence, charSequence2);
        if (charSequence2.length() == 0) {
            throw new IllegalArgumentException("The " + charSequence + " parameter cannot be an empty character sequence");
        }
    }

    public static void notWhitespace(CharSequence charSequence, CharSequence charSequence2) {
        Parameters.notNull(charSequence, charSequence2);
        if (charSequence2.toString().trim().length() == 0) {
            throw new IllegalArgumentException("The " + charSequence + " parameter must contain at least one non-whitespace character");
        }
    }

    public static void javaIdentifier(CharSequence charSequence, CharSequence charSequence2) {
        Parameters.notNull(charSequence, charSequence2);
        Parameters.javaIdentifierOrNull(charSequence, charSequence2);
    }

    public static void javaIdentifierOrNull(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2 != null && !Utilities.isJavaIdentifier(charSequence2.toString())) {
            throw new IllegalArgumentException("The " + charSequence + " parameter ('" + charSequence2 + "') is not a valid Java identifier");
        }
    }
}

