/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.OpenTypeConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.internal.ContentMashup;
import com.jrockit.mc.rjmx.services.flr.internal.EventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.internal.OptionMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class RecordingSettingsToolkit {
    public static final String KEY_ID = "id";
    public static final String KEY_THRESHOLD = "threshold";
    private static final String KEY_STACKTRACE_SERVER = "stacktrace";
    public static final String KEY_STACKTRACE_LOCAL = "stackTrace";
    private static final String KEY_PERIOD_SERVER = "requestPeriod";
    public static final String KEY_PERIOD_LOCAL = "period";
    public static final String KEY_ENABLED = "enabled";
    private static final OptionMetadata<?>[] WELL_KNOWN_OPTION_METADATA;
    private static final Map<String, OptionMetadata<?>> WELL_KNOWN_KEY_TO_OPTION_METADATA;
    private static final String[] SERVER_NAMES;
    private static final String[] SERVER_DESCRIPTIONS;
    private static final OpenType<?>[] OPEN_TYPES;
    public static final CompositeType OPTIONS_COMPOSITE_TYPE;

    static {
        WELL_KNOWN_KEY_TO_OPTION_METADATA = new HashMap();
        SERVER_NAMES = new String[]{KEY_ID, KEY_THRESHOLD, KEY_STACKTRACE_SERVER, KEY_PERIOD_SERVER, KEY_ENABLED};
        SERVER_DESCRIPTIONS = SERVER_NAMES;
        OPEN_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.BOOLEAN};
        WELL_KNOWN_OPTION_METADATA = RecordingSettingsToolkit.generateOptionsMetaData();
        RecordingSettingsToolkit.populateOptionsMap();
        OPTIONS_COMPOSITE_TYPE = RecordingSettingsToolkit.generateOptionsType();
    }

    private static CompositeType generateOptionsType() {
        CompositeType type = null;
        try {
            type = new CompositeType("EventOptions", "Event Options", SERVER_NAMES, SERVER_DESCRIPTIONS, OPEN_TYPES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    private static OptionMetadata<?>[] generateOptionsMetaData() {
        OptionMetadata[] options = new OptionMetadata[]{new OptionMetadata<Long>(KEY_THRESHOLD, ContentMashup.NANOSECONDS, "The threshold.", 0L, 31622400000000000L, 20L), new OptionMetadata<Boolean>(KEY_STACKTRACE_LOCAL, ContentMashup.BOOLEAN, "Whether or not to include stacktraces in the events.", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE), new OptionMetadata<Long>(KEY_PERIOD_LOCAL, ContentMashup.MILLIS_PERIODICITY, "The request period.", 0L, 126230400000L, 20L), new OptionMetadata<Boolean>(KEY_ENABLED, ContentMashup.BOOLEAN, "Whether or not events of this type will be included.", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE)};
        return options;
    }

    public static OptionMetadata<?> getWellKnownOptionMetaDataFor(String localKey) {
        return WELL_KNOWN_KEY_TO_OPTION_METADATA.get(localKey);
    }

    private RecordingSettingsToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static EventTypeMetadata fromCompositeData(CompositeData data) throws URISyntaxException {
        String uri = (String)data.get("uri");
        Integer id = (Integer)data.get(KEY_ID);
        String path = (String)data.get("path");
        new URI(uri);
        assert (uri.endsWith(path));
        EventTypeID eventTypeID = new EventTypeID(uri, uri.length() - path.length());
        Map<String, ?> capabilities = RecordingSettingsToolkit.extractMap(data);
        return new EventTypeMetadata(id, eventTypeID, capabilities, RecordingSettingsToolkit.getConfigurableOptions(capabilities));
    }

    public static OptionMetadata<?>[] getConfigurableOptions(Map<String, ?> capabilities) {
        ArrayList parameters = new ArrayList();
        OptionMetadata<?>[] optionMetadataArray = WELL_KNOWN_OPTION_METADATA;
        int n = WELL_KNOWN_OPTION_METADATA.length;
        int n2 = 0;
        while (n2 < n) {
            OptionMetadata<?> parameter = optionMetadataArray[n2];
            String key = parameter.getKey();
            if (RecordingSettingsToolkit.isOptionallySupported(key)) {
                if (key.equals(KEY_PERIOD_LOCAL) && RecordingSettingsToolkit.capabilitiesSupports(capabilities, "isRequestable")) {
                    parameters.add(parameter);
                } else if (key.equals(KEY_STACKTRACE_LOCAL) && RecordingSettingsToolkit.capabilitiesSupports(capabilities, "isStackTraceAvailable")) {
                    parameters.add(parameter);
                } else if (key.equals(KEY_THRESHOLD) && RecordingSettingsToolkit.capabilitiesSupports(capabilities, "isTimed")) {
                    parameters.add(parameter);
                }
            } else {
                parameters.add(parameter);
            }
            ++n2;
        }
        return parameters.toArray(new OptionMetadata[parameters.size()]);
    }

    private static boolean isOptionallySupported(String key) {
        return key.equals(KEY_PERIOD_LOCAL) || key.equals(KEY_STACKTRACE_LOCAL) || key.equals(KEY_THRESHOLD);
    }

    public static IEventSettingsHolder fromCompositeData(Map<Integer, EventTypeMetadata> typeByInt, List<CompositeData> compositeDatas) {
        EventSettingsHolder holder = new EventSettingsHolder();
        for (CompositeData data : compositeDatas) {
            Integer intID = (Integer)data.get(KEY_ID);
            EventTypeMetadata metaData = typeByInt.get(intID);
            RecordingSettingsToolkit.addOptionsTo(holder, metaData, data);
        }
        return holder;
    }

    public static List<CompositeData> toCompositeData(Collection<EventTypeMetadata> availableEventTypes, IEventSettingsHolder settings) throws OpenDataException {
        ArrayList<CompositeData> eventSettings = new ArrayList<CompositeData>();
        for (EventTypeMetadata eventType : availableEventTypes) {
            Map<EventOptionID, IConvertibleValue<?>> options = settings.getEventOptionsFor(eventType.getEventTypeID());
            eventSettings.add(RecordingSettingsToolkit.encodeAsComposite(eventType.getId(), options));
        }
        return eventSettings;
    }

    private static CompositeData encodeAsComposite(Integer intID, Map<EventOptionID, IConvertibleValue<?>> options) throws OpenDataException {
        CompositeDataSupport composite = new CompositeDataSupport(OPTIONS_COMPOSITE_TYPE, SERVER_NAMES, RecordingSettingsToolkit.generateValues(intID, options));
        return composite;
    }

    private static Object[] generateValues(Integer id, Map<EventOptionID, IConvertibleValue<?>> options) {
        Boolean stacktrace = Boolean.FALSE;
        Long requestPeriod = -1L;
        Long threshold = -1L;
        Boolean enabled = Boolean.FALSE;
        for (Map.Entry<EventOptionID, IConvertibleValue<?>> entry : options.entrySet()) {
            String key = entry.getKey().getOptionKey();
            Object value = entry.getValue().toServerOpenType();
            if (value == null) continue;
            if (KEY_ENABLED.equals(key)) {
                enabled = (Boolean)value;
                continue;
            }
            if (KEY_PERIOD_LOCAL.equals(key)) {
                requestPeriod = (Long)value;
                continue;
            }
            if (KEY_STACKTRACE_LOCAL.equals(key)) {
                stacktrace = (Boolean)value;
                continue;
            }
            if (!KEY_THRESHOLD.equals(key)) continue;
            threshold = (Long)value;
        }
        return new Object[]{id, threshold, stacktrace, requestPeriod, enabled};
    }

    private static Map<String, ?> extractMap(CompositeData data) {
        Set<String> keys = data.getCompositeType().keySet();
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            map.put(key, data.get(key));
        }
        return Collections.unmodifiableMap(map);
    }

    public static void addOptionsTo(EventSettingsHolder holder, EventTypeMetadata eventType, CompositeData data) {
        Iterator<String> iterator = data.getCompositeType().keySet().iterator();
        while (iterator.hasNext()) {
            String serverKey;
            String localKey = serverKey = iterator.next();
            if (serverKey.equals(KEY_PERIOD_SERVER)) {
                localKey = KEY_PERIOD_LOCAL;
            } else if (localKey.equals(KEY_STACKTRACE_SERVER)) {
                localKey = KEY_STACKTRACE_LOCAL;
            }
            OptionMetadata<?> constraint = WELL_KNOWN_KEY_TO_OPTION_METADATA.get(localKey);
            if (constraint == null || !RecordingSettingsToolkit.hasOptionMeta(eventType, localKey)) continue;
            EventOptionID optionID = new EventOptionID(eventType.getEventTypeID(), localKey);
            holder.add(optionID, OpenTypeConvertibleValue.createWithCast(constraint, data.get(serverKey)));
        }
    }

    private static boolean hasOptionMeta(EventTypeMetadata metadata, String key) {
        IOptionDescriptor[] optionMetas;
        IOptionDescriptor[] iOptionDescriptorArray = optionMetas = metadata.getOptionDescriptors();
        int n = optionMetas.length;
        int n2 = 0;
        while (n2 < n) {
            IOptionDescriptor optionMeta = iOptionDescriptorArray[n2];
            if (key.equals(optionMeta.getKey())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void populateOptionsMap() {
        OptionMetadata<?>[] optionMetadataArray = WELL_KNOWN_OPTION_METADATA;
        int n = WELL_KNOWN_OPTION_METADATA.length;
        int n2 = 0;
        while (n2 < n) {
            OptionMetadata<?> element = optionMetadataArray[n2];
            WELL_KNOWN_KEY_TO_OPTION_METADATA.put(element.getKey(), element);
            ++n2;
        }
    }

    private static boolean capabilitiesSupports(Map<String, ?> capabilities, String key) {
        return Boolean.TRUE.equals(capabilities.get(key));
    }
}

