/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.design.view.toolbar.ContentProvider;
import com.jrockit.mc.components.ui.design.view.toolbar.MainMenu;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPageComparator;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPageLabelProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTreeViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.Page;

public class TabPage
extends Page {
    private static final Field[] FIELDS = new Field[]{ContentProvider.FIELD_NAME};
    private StructuredViewer m_viewer;
    private Composite m_container;
    private TabPageLabelProvider m_imageProvider;

    public void createControl(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.m_container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_viewer = this.createViewer(this.m_container);
        this.m_viewer.getControl().setLayoutData((Object)gd1);
        this.m_viewer.setInput((Object)ComponentsPlugin.getDefault().getUserInterfaceRepository());
        this.refresh();
    }

    public void refresh() {
        if (this.m_viewer != null && !this.m_viewer.getControl().isDisposed()) {
            DisplayToolkit.safeAsyncExec((Widget)this.m_viewer.getControl(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    TabPage.this.m_imageProvider.clear();
                    TabPage.this.m_viewer.refresh();
                }
            });
        }
    }

    private StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 2306);
        this.m_imageProvider = new TabPageLabelProvider((Device)parent.getDisplay());
        FieldTreeViewer viewer = new FieldTreeViewer(tree, FIELDS);
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(viewer.getFields(), (IBaseLabelProvider)this.m_imageProvider));
        viewer.setComparator((ViewerComparator)new TabPageComparator());
        this.hookSelectionClick((TreeViewer)viewer);
        this.hookContextMenu((Viewer)viewer);
        return viewer;
    }

    private void hookSelectionClick(final TreeViewer viewer) {
        viewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ViewerCell cell = viewer.getCell(new Point(e.x, e.y));
                if (cell != null && cell.getElement() != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(cell.getElement()));
                } else {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    private void hookContextMenu(Viewer viewer) {
        MainMenu menuManager = new MainMenu(viewer, this.m_imageProvider);
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("jrockit.mc.designer.viewer.tabs", (MenuManager)menuManager, (ISelectionProvider)viewer);
    }

    public Control getControl() {
        return this.m_container;
    }

    public void setFocus() {
        if (this.m_container != null && !this.m_container.isDisposed()) {
            this.m_container.setFocus();
        }
    }
}

