/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.util.ChartRenderingToolkit;

public abstract class AbstractSampler {
    private final SamplePoint[] samples;
    protected double m_maxY = Double.NEGATIVE_INFINITY;
    protected double m_minY = Double.POSITIVE_INFINITY;

    public AbstractSampler(int size) {
        this.samples = new SamplePoint[size];
    }

    protected SamplePoint getSamplePoint(int index) {
        if (this.samples[index] == null) {
            this.samples[index] = new SamplePoint(index);
        }
        return this.samples[index];
    }

    protected int getIndex(double x) {
        return (int)ChartRenderingToolkit.fastFloor(x);
    }

    public SamplePoint[] getSamples() {
        return this.samples;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.samples.length) {
            builder.append(String.valueOf(i));
            builder.append("  ");
            builder.append(this.samples[i]);
            builder.append('\n');
            ++i;
        }
        return builder.toString();
    }

    public int getSize() {
        return this.samples.length;
    }

    public double getMaxY() {
        this.calculateStatistics();
        return this.m_maxY;
    }

    public double getMinY() {
        this.calculateStatistics();
        return this.m_minY;
    }

    private void calculateStatistics() {
        if (Double.isInfinite(this.m_maxY)) {
            this.m_maxY = Double.NaN;
            this.m_minY = Double.NaN;
            SamplePoint[] samplePointArray = this.samples;
            int n = this.samples.length;
            int n2 = 0;
            while (n2 < n) {
                SamplePoint sample = samplePointArray[n2];
                if (sample != null) {
                    if (Double.isNaN(this.m_maxY)) {
                        this.m_maxY = sample.y;
                        this.m_minY = sample.y;
                    }
                    this.m_maxY = Math.max(sample.y, this.m_maxY);
                    this.m_minY = Math.min(sample.y, this.m_minY);
                }
                ++n2;
            }
        }
    }

    protected void invalidateStatistics() {
        this.m_maxY = Double.NEGATIVE_INFINITY;
        this.m_minY = Double.POSITIVE_INFINITY;
    }
}

