/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.HoverProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ObjectScene
extends Scene {
    private static final ObjectSceneListener[] EMPTY_LISTENERS = new ObjectSceneListener[0];
    private static final Set<Object> EMPTY_SET = Collections.unmodifiableSet(Collections.emptySet());
    private static final Widget[] EMPTY_WIDGETS_ARRAY = new Widget[0];
    private static final List<Widget> EMPTY_WIDGETS_LIST = Collections.emptyList();
    private HashMap<Object, Object> objects = new HashMap();
    private Set<Object> objectsUm = Collections.unmodifiableSet(this.objects.keySet());
    private HashMap<Object, Widget> object2widget = new HashMap();
    private HashMap<Object, List<Widget>> object2widgets = new HashMap();
    private HashMap<Widget, Object> widget2object = new HashMap();
    private HashMap<Object, ObjectState> objectStates = new HashMap();
    private HashSet<Object> selectedObjects = new HashSet();
    private Set<Object> selectedObjectsUm = Collections.unmodifiableSet(this.selectedObjects);
    private HashSet<Object> highlightedObjects = new HashSet();
    private Set<Object> highlightedObjectsUm = Collections.unmodifiableSet(this.highlightedObjects);
    private Object focusedObject = null;
    private Object hoveredObject = null;
    private WidgetAction selectAction = ActionFactory.createSelectAction(new ObjectSelectProvider(), true);
    private WidgetAction objectHoverAction;
    private Map<ObjectSceneEventType, List<ObjectSceneListener>> listeners = new EnumMap<ObjectSceneEventType, List<ObjectSceneListener>>(ObjectSceneEventType.class);
    private ObjectSceneEvent event = new ObjectSceneEvent(this);

    public final void addObject(Object object, Widget ... widgetArray) {
        Widget widget;
        assert (object != null && !(object instanceof Widget) && !this.objects.containsKey(object));
        Widget widget2 = widget = widgetArray.length > 0 ? widgetArray[0] : null;
        if (widget == null) {
            widgetArray = EMPTY_WIDGETS_ARRAY;
        }
        for (Widget object2 : widgetArray) {
            assert (object2 != null);
            assert (!this.widget2object.containsKey(object2) && object2.getScene() == this);
        }
        this.objects.put(object, object);
        this.object2widget.put(object, widget);
        this.object2widgets.put(object, widget != null ? Arrays.asList(widgetArray) : EMPTY_WIDGETS_LIST);
        this.objectStates.put(object, ObjectState.createNormal());
        for (Widget widget3 : widgetArray) {
            this.widget2object.put(widget3, object);
            widget3.setState(ObjectState.createNormal());
        }
        for (ObjectSceneListener objectSceneListener : this.getListeners(ObjectSceneEventType.OBJECT_ADDED)) {
            objectSceneListener.objectAdded(this.event, object);
        }
    }

    public final void removeObject(Object object) {
        Collection<Object> collection;
        assert (object != null && this.objects.containsKey(object));
        if (this.selectedObjects.contains(object)) {
            collection = new HashSet<Object>(this.selectedObjects);
            ((HashSet)collection).remove(object);
            this.setSelectedObjects((Set<?>)collection);
        }
        if (this.highlightedObjects.contains(object)) {
            collection = new HashSet<Object>(this.highlightedObjects);
            ((HashSet)collection).remove(object);
            this.setHighlightedObjects((Set<?>)collection);
        }
        if (object.equals(this.hoveredObject)) {
            this.setHoveredObject(null);
        }
        if (object.equals(this.focusedObject)) {
            this.setFocusedObject(null);
        }
        this.objectStates.remove(object);
        this.object2widget.remove(object);
        collection = this.object2widgets.remove(object);
        for (Widget widget : collection) {
            this.widget2object.remove(widget);
        }
        this.objects.remove(object);
        for (ObjectSceneListener objectSceneListener : this.getListeners(ObjectSceneEventType.OBJECT_REMOVED)) {
            objectSceneListener.objectRemoved(this.event, object);
        }
    }

    public final Set<?> getObjects() {
        return this.objectsUm;
    }

    public final boolean isObject(Object object) {
        return this.objects.containsKey(object);
    }

    public final Set<?> getSelectedObjects() {
        return this.selectedObjectsUm;
    }

    public final void setSelectedObjects(Set<?> set) {
        ObjectState objectState;
        ObjectSceneListener[] objectSceneListenerArray = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] objectSceneListenerArray2 = this.getListeners(ObjectSceneEventType.OBJECT_SELECTION_CHANGED);
        Set<Object> set2 = objectSceneListenerArray2.length != 0 ? Collections.unmodifiableSet(new HashSet<Object>(this.selectedObjects)) : EMPTY_SET;
        Iterator<Object> iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (set.contains(object2)) continue;
            iterator.remove();
            objectState = this.objectStates.get(object2);
            ObjectState object4 = objectState.deriveSelected(false);
            this.objectStates.put(object2, object4);
            for (Widget widget : this.object2widgets.get(object2)) {
                widget.setState(widget.getState().deriveSelected(false));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, object2, objectState, object4);
            }
        }
        for (Object object2 : set) {
            if (this.selectedObjects.contains(object2)) continue;
            this.selectedObjects.add(object2);
            objectState = this.objectStates.get(object2);
            ObjectState objectState2 = objectState.deriveSelected(true);
            this.objectStates.put(object2, objectState2);
            for (Widget widget : this.object2widgets.get(object2)) {
                widget.setState(widget.getState().deriveSelected(true));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, object2, objectState, objectState2);
            }
        }
        for (Iterator<Object> iterator2 : objectSceneListenerArray2) {
            iterator2.selectionChanged(this.event, set2, this.selectedObjectsUm);
        }
    }

    public final Set<?> getHighlightedObjects() {
        return this.highlightedObjectsUm;
    }

    public final void setHighlightedObjects(Set<?> set) {
        ObjectState objectState;
        ObjectSceneListener[] objectSceneListenerArray = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] objectSceneListenerArray2 = this.getListeners(ObjectSceneEventType.OBJECT_HIGHLIGHTING_CHANGED);
        Set<Object> set2 = objectSceneListenerArray2.length != 0 ? Collections.unmodifiableSet(new HashSet<Object>(this.highlightedObjects)) : EMPTY_SET;
        Iterator<Object> iterator = this.highlightedObjects.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (set.contains(object2)) continue;
            iterator.remove();
            objectState = this.objectStates.get(object2);
            ObjectState object4 = objectState.deriveHighlighted(false);
            this.objectStates.put(object2, object4);
            for (Widget widget : this.object2widgets.get(object2)) {
                widget.setState(widget.getState().deriveHighlighted(false));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, object2, objectState, object4);
            }
        }
        for (Object object2 : set) {
            if (this.highlightedObjects.contains(object2)) continue;
            this.highlightedObjects.add(object2);
            objectState = this.objectStates.get(object2);
            ObjectState objectState2 = objectState.deriveHighlighted(true);
            this.objectStates.put(object2, objectState2);
            for (Widget widget : this.object2widgets.get(object2)) {
                widget.setState(widget.getState().deriveHighlighted(true));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, object2, objectState, objectState2);
            }
        }
        for (Iterator<Object> iterator2 : objectSceneListenerArray2) {
            iterator2.highlightingChanged(this.event, set2, this.highlightedObjectsUm);
        }
    }

    public final Object getHoveredObject() {
        return this.hoveredObject;
    }

    public final void setHoveredObject(Object object) {
        ObjectState objectState;
        Object object2;
        if (object != null ? object.equals(this.hoveredObject) : this.hoveredObject == null) {
            return;
        }
        ObjectSceneListener[] objectSceneListenerArray = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] objectSceneListenerArray2 = this.getListeners(ObjectSceneEventType.OBJECT_HOVER_CHANGED);
        Object object3 = this.hoveredObject;
        if (this.hoveredObject != null) {
            object2 = this.objectStates.get(this.hoveredObject);
            objectState = ((ObjectState)object2).deriveObjectHovered(false);
            this.objectStates.put(this.hoveredObject, objectState);
            for (Widget widget : this.object2widgets.get(this.hoveredObject)) {
                widget.setState(widget.getState().deriveObjectHovered(false));
            }
            for (ObjectSceneListener object4 : objectSceneListenerArray) {
                object4.objectStateChanged(this.event, this.hoveredObject, (ObjectState)object2, objectState);
            }
        }
        this.hoveredObject = object;
        if (this.hoveredObject != null) {
            object2 = this.objectStates.get(this.hoveredObject);
            objectState = ((ObjectState)object2).deriveObjectHovered(true);
            this.objectStates.put(this.hoveredObject, objectState);
            for (Widget widget : this.object2widgets.get(this.hoveredObject)) {
                widget.setState(widget.getState().deriveObjectHovered(true));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, this.hoveredObject, (ObjectState)object2, objectState);
            }
        }
        for (ObjectSceneListener objectSceneListener : objectSceneListenerArray2) {
            objectSceneListener.hoverChanged(this.event, object3, this.hoveredObject);
        }
    }

    public final Object getFocusedObject() {
        return this.focusedObject;
    }

    public final void setFocusedObject(Object object) {
        ObjectState objectState;
        Object object2;
        if (object != null ? object.equals(this.focusedObject) : this.focusedObject == null) {
            return;
        }
        ObjectSceneListener[] objectSceneListenerArray = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] objectSceneListenerArray2 = this.getListeners(ObjectSceneEventType.OBJECT_FOCUS_CHANGED);
        Object object3 = this.focusedObject;
        if (this.focusedObject != null) {
            object2 = this.objectStates.get(this.focusedObject);
            objectState = ((ObjectState)object2).deriveObjectFocused(false);
            this.objectStates.put(this.focusedObject, objectState);
            for (Widget widget : this.object2widgets.get(this.focusedObject)) {
                widget.setState(widget.getState().deriveObjectFocused(false));
            }
            for (ObjectSceneListener object4 : objectSceneListenerArray) {
                object4.objectStateChanged(this.event, this.focusedObject, (ObjectState)object2, objectState);
            }
        }
        this.focusedObject = object;
        if (this.focusedObject != null) {
            object2 = this.objectStates.get(this.focusedObject);
            objectState = ((ObjectState)object2).deriveObjectFocused(true);
            this.objectStates.put(this.focusedObject, objectState);
            for (Widget widget : this.object2widgets.get(this.focusedObject)) {
                widget.setState(widget.getState().deriveObjectFocused(true));
            }
            for (ObjectSceneListener objectSceneListener : objectSceneListenerArray) {
                objectSceneListener.objectStateChanged(this.event, this.focusedObject, (ObjectState)object2, objectState);
            }
            this.setFocusedWidget(this.object2widget.get(this.focusedObject));
        } else {
            this.setFocusedWidget(null);
        }
        for (ObjectSceneListener objectSceneListener : objectSceneListenerArray2) {
            objectSceneListener.focusChanged(this.event, object3, this.focusedObject);
        }
    }

    public final WidgetAction createSelectAction() {
        return this.selectAction;
    }

    public final WidgetAction createObjectHoverAction() {
        if (this.objectHoverAction == null) {
            this.objectHoverAction = ActionFactory.createHoverAction(new ObjectHoverProvider());
            this.getActions().addAction(this.objectHoverAction);
        }
        return this.objectHoverAction;
    }

    public final Widget findWidget(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.object2widget.get(object);
    }

    public final List<Widget> findWidgets(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.object2widgets.get(object);
    }

    public final Object findObject(Widget widget) {
        while (widget != null) {
            Object object = this.widget2object.get(widget);
            if (object != null) {
                return object;
            }
            widget = widget.getParentWidget();
        }
        return null;
    }

    public final Object findStoredObject(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.objects.get(object);
    }

    public final ObjectState getObjectState(Object object) {
        return this.objectStates.get(object);
    }

    public void userSelectionSuggested(Set<?> set, boolean bl) {
        if (bl) {
            HashSet hashSet = new HashSet(this.getSelectedObjects());
            for (Object obj : set) {
                if (hashSet.contains(obj)) {
                    hashSet.remove(obj);
                    continue;
                }
                hashSet.add(obj);
            }
            this.setSelectedObjects(hashSet);
        } else {
            this.setSelectedObjects(set);
        }
    }

    public Comparable getIdentityCode(Object object) {
        return object != null ? Integer.valueOf(System.identityHashCode(object)) : null;
    }

    public final void addObjectSceneListener(ObjectSceneListener objectSceneListener, ObjectSceneEventType ... objectSceneEventTypeArray) {
        for (ObjectSceneEventType objectSceneEventType : objectSceneEventTypeArray) {
            this.addObjectSceneListenerCore(objectSceneListener, objectSceneEventType);
        }
    }

    private void addObjectSceneListenerCore(ObjectSceneListener objectSceneListener, ObjectSceneEventType objectSceneEventType) {
        List<ObjectSceneListener> list = this.listeners.get((Object)objectSceneEventType);
        if (list == null) {
            list = new ArrayList<ObjectSceneListener>();
            this.listeners.put(objectSceneEventType, list);
        }
        list.add(objectSceneListener);
    }

    public final void removeObjectSceneListener(ObjectSceneListener objectSceneListener, ObjectSceneEventType ... objectSceneEventTypeArray) {
        for (ObjectSceneEventType objectSceneEventType : objectSceneEventTypeArray) {
            this.removeObjectSceneListenerCore(objectSceneListener, objectSceneEventType);
        }
    }

    private void removeObjectSceneListenerCore(ObjectSceneListener objectSceneListener, ObjectSceneEventType objectSceneEventType) {
        List<ObjectSceneListener> list = this.listeners.get((Object)objectSceneEventType);
        if (list == null) {
            return;
        }
        list.remove(objectSceneListener);
        if (list.isEmpty()) {
            this.listeners.remove((Object)objectSceneEventType);
        }
    }

    private ObjectSceneListener[] getListeners(ObjectSceneEventType objectSceneEventType) {
        List<ObjectSceneListener> list = this.listeners.get((Object)objectSceneEventType);
        if (list == null) {
            return EMPTY_LISTENERS;
        }
        return list.toArray(new ObjectSceneListener[list.size()]);
    }

    private class ObjectHoverProvider
    implements HoverProvider {
        private ObjectHoverProvider() {
        }

        @Override
        public void widgetHovered(Widget widget) {
            if (ObjectScene.this == widget) {
                widget = null;
            }
            ObjectScene.this.setHoveredObject(ObjectScene.this.findObject(widget));
        }
    }

    private class ObjectSelectProvider
    implements SelectProvider {
        private ObjectSelectProvider() {
        }

        @Override
        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        @Override
        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return ObjectScene.this.findObject(widget) != null;
        }

        @Override
        public void select(Widget widget, Point point, boolean bl) {
            Object object = ObjectScene.this.findObject(widget);
            ObjectScene.this.setFocusedObject(object);
            if (object != null) {
                if (!bl && ObjectScene.this.getSelectedObjects().contains(object)) {
                    return;
                }
                ObjectScene.this.userSelectionSuggested(Collections.singleton(object), bl);
            } else {
                ObjectScene.this.userSelectionSuggested(Collections.emptySet(), bl);
            }
        }
    }
}

